mwaextraadminImageResizer.IMAGE_ID_BASE = 'mwaextraadmin_imageresizer_container_';
mwaextraadminImageResizer.WARNING_ID_BASE = 'mwaextraadmin_imageresizer_warning_';

function mwaextraadminImageResizer(id, img) {
	this.id = id;
	this.img = img;
	this.originalWidth = 0;
	this.originalHeight = 0;
	this.warning = null;
	this.warningTextNode = null;
	
	img.id = mwaextraadminImageResizer.IMAGE_ID_BASE+id;
}

mwaextraadminImageResizer.getNextId = function() {
	id = 1;
	while(document.getElementById(mwaextraadminImageResizer.IMAGE_ID_BASE+id) != null) {
		id++;
	}
	return id;
}

mwaextraadminImageResizer.createOnId = function(id) {
	return mwaextraadminImageResizer.createOn(document.getElementById(id));
}

mwaextraadminImageResizer.createOn = function(img) {
	if(!img.tries || typeof img.tries == 'undefined') {
		img.tries = 1;
	} else {
		img.tries++;
	}
	
	if((img.width == 0 || img.height == 0) && img.tries < 4) {
		var ran = Math.floor(Math.random()*100000);
		img.id = ran;
		setTimeout('mwaextraadminImageResizer.createOnId("'+ran+'");', 500);
		return;
	}
	
	isRecovery = false; // if this is a recovery from QuickEdit, which only restores the HTML, not the OO structure
	if(img.id && img.id.indexOf(mwaextraadminImageResizer.IMAGE_ID_BASE) == 0 && document.getElementById(mwaextraadminImageResizer.WARNING_ID_BASE+img.id.substr(mwaextraadminImageResizer.IMAGE_ID_BASE.length)) != null) {
		newid = img.id.substr(mwaextraadminImageResizer.IMAGE_ID_BASE.length);
		resizer = new mwaextraadminImageResizer(newid, img);
		isRecovery = true;
		resizer.restoreImage();
	} else {
		newid = mwaextraadminImageResizer.getNextId();
		resizer = new mwaextraadminImageResizer(id, img);
	}
	
	if (resizer.originalWidth == 0) resizer.originalWidth = img.width;
	if (resizer.originalHeight == 0) resizer.originalHeight = img.height;
	
	if((mwaextraadminImageResizer.MAXWIDTH > 0 && resizer.originalWidth > mwaextraadminImageResizer.MAXWIDTH) || (mwaextraadminImageResizer.MAXHEIGHT > 0 && resizer.originalHeight > mwaextraadminImageResizer.MAXHEIGHT)) {
		if(isRecovery) {
			resizer.reclaimWarning(warning);
		} else {
			resizer.createWarning();
		}
		resizer.scale();
	}
}

mwaextraadminImageResizer.prototype.restoreImage = function() {
	newimg = document.createElement('IMG');
	newimg.src = this.img.src;
	this.img.width = newimg.width;
	this.img.height = newimg.height;
}

mwaextraadminImageResizer.prototype.reclaimWarning = function() {
	warning = document.getElementById(mwaextraadminImageResizer.WARNING_ID_BASE+newid);
	
	this.warning = warning;
	this.warningTextNode = warning.firstChild.firstChild.childNodes[1].firstChild;
	this.warning.resize = this;
	
	this.scale();
}

mwaextraadminImageResizer.prototype.createWarning = function() {
	mtable = document.createElement('TABLE');
	mtbody = document.createElement('TBODY');
	mtr = document.createElement('TR');
	mtd1 = document.createElement('TD');
	mtd2 = document.createElement('TD');
	mimg = document.createElement('IMG');
	mtext = document.createTextNode('');
	
	mimg.src = 'images/statusicon/wol_error.gif';
	mimg.width = 16;
	mimg.height = 16;
	mimg.alt = '';
	mimg.border = 0;
	
	mtd1.width = 20;
	mtd1.className = 'td1';
	
	mtd2.unselectable = 'on';
	mtd2.className = 'td2';
	
	mtable.className = 'mwaextraadmin_imageresizer_warning';
	mtable.textNode = mtext;
	mtable.resize = this;
	mtable.id = mwaextraadminImageResizer.WARNING_ID_BASE+this.id;
	
	mtd1.appendChild(mimg);
	mtd2.appendChild(mtext);
	
	mtr.appendChild(mtd1);
	mtr.appendChild(mtd2);
	
	mtbody.appendChild(mtr);
	
	mtable.appendChild(mtbody);
	
	this.img.parentNode.insertBefore(mtable, this.img);
	
	this.warning = mtable;
	this.warningTextNode = mtext;
}

mwaextraadminImageResizer.prototype.scale = function() {
	this.img.height = this.originalHeight;
	this.img.width = this.originalWidth;
	
	if(mwaextraadminImageResizer.MAXWIDTH > 0 && this.img.width > mwaextraadminImageResizer.MAXWIDTH) {
		resized = true;
		this.img.height = (mwaextraadminImageResizer.MAXWIDTH / this.img.width) * this.img.height;
		this.img.width = mwaextraadminImageResizer.MAXWIDTH;
	}
	
	if(mwaextraadminImageResizer.MAXHEIGHT > 0 && this.img.height > mwaextraadminImageResizer.MAXHEIGHT) {
		resized = true;
		this.img.width = (mwaextraadminImageResizer.MAXHEIGHT / this.img.height) * this.img.width;
		this.img.height = mwaextraadminImageResizer.MAXHEIGHT;
	}
	
	this.warning.width = this.img.width;
	this.warning.onclick = function() { return this.resize.unScale(); }
	
	if(this.img.width < 450) {
		this.warningTextNode.data = vbphrase['mwaextraadmin_imageresizer_warning_small'];
	} else if(this.img.fileSize && this.img.fileSize > 0) {
		this.warningTextNode.data = vbphrase['mwaextraadmin_imageresizer_warning_filesize'].replace('%1$s', this.originalWidth).replace('%2$s', this.originalHeight).replace('%3$s', Math.round(this.img.fileSize/1024));
		//mtext.data = '<phrase 1="'+this.originalWidth+'" 2="'+this.originalHeight+'" 3="'+Math.round(this.img.fileSize/1024)+'">$vbphrase[mwaextraadmin_imageresizer_warning_filesize]</phrase>';
	} else {
		this.warningTextNode.data = vbphrase['mwaextraadmin_imageresizer_warning_no_filesize'].replace('%1$s', this.originalWidth).replace('%2$s', this.originalHeight);
		//mtext.data = '<phrase 1="'+this.originalWidth+'" 2="'+this.originalHeight+'">$vbphrase[mwaextraadmin_imageresizer_warning_no_filesize]</phrase>';
	}
	
	return false;
}

mwaextraadminImageResizer.prototype.unScale = function() {
	switch(mwaextraadminImageResizer.MODE) {
		case 'samewindow':
			window.open(this.img.src, '_self');
			break;
		case 'newwindow':
			window.open(this.img.src, '_blank');
			break;
		case 'enlarge':
		default:
			this.img.width = this.originalWidth;
			this.img.height = this.originalHeight;
			this.img.className = 'mwaextraadmin_imageresizer_original';
			if(this.warning != null) {
				this.warningTextNode.data = vbphrase['mwaextraadmin_imageresizer_warning_fullsize'];
				this.warning.width = this.img.width;
				this.warning.onclick = function() { return this.resize.scale() };
			}
			break;
	}
	
	return false;
}